<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <link rel="icon" href="/assets/images/logo-left.png" type="image/x-icon">
    <title><?php echo $title ?? 'MIA Patriote'; ?></title>
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@400;500;600&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css">
    <link href="https://fonts.googleapis.com/css2?family=Montserrat:ital,wght@0,100..900;1,100..900&display=swap" rel="stylesheet">
    <link href="https://fonts.googleapis.com/css2?family=Big+Shoulders+Text:wght@100..900&family=DM+Serif+Display:ital@0;1&family=Montserrat:ital,wght@0,100..900;1,100..900&family=Roboto+Slab:wght@100..900&display=swap" rel="stylesheet">
    <link href="assets/css/bootstrap/bootstrap.min.css" rel="stylesheet">
    <link href="assets/css/app.css" rel="stylesheet">
</head>
<body>
    <header class="container-fluid">
        <div class="d-flex justify-content-between mx-3">
            <div class="left" style="">
                <a href="/" data-turbo-action="replace">
                    <img src="/assets/images/logo-left.png" alt="Logo" class="logo-left">
                </a>
            </div>
            <div class="right">
                <img src="/assets/images/logo-right.png" alt="Logo" class="logo-right">
            </div>
        </div>
    </header>

    <?php echo $content ?? ''; ?>

    <footer class="container-fluid">
        <div class="col-md-8 mx-auto">
            <div class="d-flex justify-content-evenly link">
                <p>Specification Sheet</p>
                <p>Order Now</p>
                <p><a href="mailto:contact-info@mia-global.com">Contact-info@mia-global.com</a></p>
            </div>
        </div>
        <div class="d-flex justify-content-center mx-3">
            <img src="/assets/images/logo-left.png" alt="Logo" class="logo-footer-left">
            <img src="/assets/images/logo-right.png" alt="Logo" class="logo-footer-right">
        </div>
    </footer>

    <script src="assets/js/bootstrap/bootstrap.min.js" ></script>
    <script src="assets/js/jquery/jquery-3.7.1.min.js" ></script>
    <script type="module" src="https://cdn.jsdelivr.net/npm/@hotwired/turbo@7.2.0/dist/turbo.es2017-esm.js"></script>
    <script src="assets/js/app.js"></script>
</body>
</html>