<?php

use Mia\Patriote\Config\Router;

require_once '../vendor/autoload.php';

$dotenv = parse_ini_file(__DIR__ . '/../.env');
foreach ($dotenv as $key => $value) {
    putenv("$key=$value");
}

require_once '../config/Database.php';
require_once '../config/Router.php';
require_once '../src/Controller/HomeController.php';
require_once '../src/Controller/OrderController.php';

$router = new Router();

$router->addRoute('/', 'HomeController', 'index');
//$router->addRoute('/order', 'OrderController', 'detail');

// Get the current URL path
$url = $_SERVER['REQUEST_URI'];
$url = strtok($url, '?'); // Remove query string if present

try {
    $router->dispatch($url);
} catch (Exception $e) {
}