document.addEventListener("turbo:before-fetch-request", function(e){
    Turbo.navigator.delegate.adapter.showProgressBar();
})
document.addEventListener("turbo:frame-render", function(e) {
    Turbo.navigator.delegate.adapter.progressBar.hide()
})

fetch('/assets/data/countries.json')
    .then(response => response.json())
    .then(data => {
        const countrySelect = document.querySelector('.country');

        data.countries.forEach(country => {
            const option = document.createElement('option');
            option.value = country;
            option.textContent = country;
            if (country === 'Romania') {
                option.selected = true;
            }
            countrySelect.appendChild(option);
        });
    })
    .catch(error => console.error('Error fetching the countries:', error));