<?php

namespace Mia\Patriote\Config;

class Router
{
    private array $routes = [];

    public function addRoute($url, $controller, $method)
    {
        $this->routes[$url] = ['controller' => $controller, 'method' => $method];
    }

    /**
     * @throws \Exception
     */
    public function dispatch($url)
    {
        if (array_key_exists($url, $this->routes)) {
            $controller = $this->routes[$url]['controller'];
            $method = $this->routes[$url]['method'];

            $controllerClass = "Mia\\Patriote\\Controller\\" . $controller;

            if (class_exists($controllerClass)) {
                $controllerInstance = new $controllerClass();
                $controllerInstance->$method();
            } else {
                throw new \Exception("Controller class $controllerClass not found");
            }
        } else {
            header("HTTP/1.0 404 Not Found");
            echo "404 Not Found";
        }
    }
}